<?php
// member_manager.php
require_once 'db_model.php'; // Includes config.php

global $conn;
$message = '';
$groups_list = get_all_groups($conn);

// --- Handle Group Submission ---
if (isset($_POST['add_group'])) {
    $group_name = trim($_POST['new_group_name']);
    if (!empty($group_name)) {
        if (add_new_group($conn, $group_name)) {
            $message = '<p class="success">Group "' . htmlspecialchars($group_name) . '" added successfully!</p>';
            $groups_list = get_all_groups($conn); // Reload list
        } else {
            $message = '<p class="error">Error adding group: ' . $conn->error . '</p>';
        }
    } else {
        $message = '<p class="error">Group name cannot be empty.</p>';
    }
}

// --- Handle Member Submission ---
if (isset($_POST['add_member'])) {
    $group_id = intval($_POST['group_id']);
    $member_no = intval($_POST['member_no']);
    $name_details = trim($_POST['member_name']);
    
    if ($group_id > 0 && $member_no > 0 && !empty($name_details)) {
        if (add_new_member($conn, $group_id, $member_no, $name_details)) {
            $message = '<p class="success">Member "' . htmlspecialchars($name_details) . '" added to Group ID ' . $group_id . '.</p>';
        } else {
            $message = '<p class="error">Error adding member: Check if Member No. ' . $member_no . ' is already used or if Group ID is valid. ' . $conn->error . '</p>';
        }
    } else {
        $message = '<p class="error">Please fill all fields correctly.</p>';
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>SEEPO RLF - Admin Management</title>
    <link rel="stylesheet" href="styles.css">
    <style>
        .container { max-width: 800px; margin: 40px auto; padding: 20px; background-color: #424242; border-radius: 8px; box-shadow: 0 0 10px rgba(0, 0, 0, 0.5); }
        .form-box { margin-bottom: 30px; padding: 20px; border: 1px solid #7c43bd; border-radius: 5px; }
        .form-box h3 { color: #8bc34a; border-bottom: 1px solid #7c43bd; padding-bottom: 10px; }
        input[type="text"], input[type="number"], select { width: 100%; padding: 10px; margin: 8px 0 15px; box-sizing: border-box; background-color: #333; color: #fff; border: 1px solid #7c43bd; border-radius: 4px; }
        button[type="submit"] { background-color: #6a1b9a; color: white; padding: 10px 15px; border: none; border-radius: 4px; cursor: pointer; }
        .success { color: #8bc34a; font-weight: bold; }
        .error { color: #ff5252; font-weight: bold; }
    </style>
</head>
<body>
    <header>
        <h1>Admin Management</h1>
        <h2>Add Groups and Members</h2>
    </header>

    <div class="container">
        <?php echo $message; ?>

        <div class="form-box">
            <h3>➕ Add New Group</h3>
            <form method="POST" action="member_manager.php">
                <label for="new_group_name">Group Name:</label>
                <input type="text" id="new_group_name" name="new_group_name" required>
                <button type="submit" name="add_group">Add Group</button>
            </form>
        </div>

        <div class="form-box">
            <h3>👤 Add New Member</h3>
            <form method="POST" action="member_manager.php">
                <label for="group_id">Assign to Group:</label>
                <select id="group_id" name="group_id" required>
                    <option value="">-- Select Group --</option>
                    <?php foreach ($groups_list as $group): ?>
                        <option value="<?php echo htmlspecialchars($group['group_id']); ?>">
                            <?php echo htmlspecialchars($group['group_name']); ?>
                        </option>
                    <?php endforeach; ?>
                </select>

                <label for="member_no">Member No (M/NO):</label>
                <input type="number" id="member_no" name="member_no" required>
                
                <label for="member_name">Member Name & Details:</label>
                <input type="text" id="member_name" name="member_name" required>

                <button type="submit" name="add_member">Add Member</button>
            </form>
        </div>
        
        <p style="text-align: center;"><a href="index.php" style="color: #ffb74d;">← Back to Ledger Entry</a></p>

    </div>
    
    <?php close_db_connection($conn); ?>
</body>
</html>