<?php
// password_hasher.php
// A simple utility to generate secure password hashes for database insertion.
// Uses PHP's native password_hash() function with the PASSWORD_DEFAULT algorithm.

$password = '';
$hash = '';
$message = 'Enter a password to generate its secure hash.';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['password'])) {
    $password = $_POST['password'];

    if (empty($password)) {
        $message = '<span style="color: #ff5252;">Please enter a password.</span>';
    } else {
        // Generate the secure hash
        $hash = password_hash($password, PASSWORD_DEFAULT);

        // Success message
        $message = '<span style="color: #8bc34a; font-weight: bold;">Hash Generated Successfully!</span>';
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Password Hash Generator</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@400;700&display=swap');
        body {
            font-family: 'Inter', sans-serif;
            background: linear-gradient(135deg, #2a2a2a 0%, #1e1e1e 100%);
            color: #fff;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            margin: 0;
            padding: 20px;
        }
        .container {
            background-color: #3a3a3a;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.4);
            width: 100%;
            max-width: 600px;
            box-sizing: border-box;
            border-top: 5px solid #8bc34a;
        }
        h1 {
            color: #8bc34a;
            text-align: center;
            margin-bottom: 20px;
            font-size: 1.5em;
        }
        .message {
            text-align: center;
            margin-bottom: 20px;
            padding: 10px;
            background: #2a2a2a;
            border-radius: 6px;
        }
        .form-group {
            margin-bottom: 20px;
        }
        label {
            display: block;
            margin-bottom: 8px;
            font-weight: 700;
            color: #ccc;
        }
        input[type="text"],
        input[type="password"],
        textarea {
            width: 100%;
            padding: 12px;
            background-color: #444;
            border: 1px solid #555;
            color: #fff;
            border-radius: 6px;
            box-sizing: border-box;
            resize: none;
        }
        .generate-btn {
            width: 100%;
            padding: 12px;
            background-color: #7c43bd;
            color: #fff;
            border: none;
            border-radius: 6px;
            font-size: 16px;
            font-weight: bold;
            cursor: pointer;
            transition: background-color 0.3s;
        }
        .generate-btn:hover {
            background-color: #6a3a99;
        }
        .hash-output {
            margin-top: 25px;
            border-top: 1px dashed #555;
            padding-top: 15px;
        }
        .hash-output label {
            color: #8bc34a;
        }
        .hash-output textarea {
            height: 100px;
            background-color: #222;
            border-color: #8bc34a;
            font-size: 0.9em;
            word-wrap: break-word;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>PHP Password Hash Generator</h1>
        <div class="message"><?php echo $message; ?></div>
        
        <form method="POST" action="">
            <div class="form-group">
                <label for="password">Enter Password:</label>
                <input type="password" id="password" name="password" required autofocus>
            </div>
            <button type="submit" class="generate-btn">GENERATE HASH</button>
        </form>

        <?php if (!empty($hash)): ?>
            <div class="hash-output">
                <label>Generated Hash (Copy this to your database):</label>
                <textarea readonly onclick="this.select();"><?php echo htmlspecialchars($hash); ?></textarea>
                <p style="font-size: 0.8em; color: #aaa;">This hash is for the password: **<?php echo htmlspecialchars($password); ?>**</p>
            </div>
        <?php endif; ?>
    </div>
</body>
</html>
