<?php
// index.php
require_once 'ledger_controller.php';

// --- Function to generate the group selection dropdown ---
function generate_group_dropdown($groups_list, $selected_group_id) {
    $html = '<label for="group_select">Select Group:</label>';
    $html .= '<select id="group_select" onchange="window.location.href = \'index.php?group_id=\' + this.value;">';
    $html .= '<option value="">-- Choose a Group --</option>';
    
    foreach ($groups_list as $group) {
        $selected = ($group['group_id'] == $selected_group_id) ? 'selected' : '';
        $html .= '<option value="' . $group['group_id'] . '" ' . $selected . '>' . htmlspecialchars($group['group_name']) . '</option>';
    }
    $html .= '</select>';
    return $html;
}

// Function to generate the dynamic table rows (Uses member_no)
function generate_member_rows($members_data) {
    $html = '';
    foreach ($members_data as $data) {
        $member_no_field = '<input type="hidden" name="member_no[]" value="' . htmlspecialchars($data['member_no']) . '">';
        
        $html .= '<tr>';
        $html .= '<td>' . htmlspecialchars($data['member_no']) . $member_no_field . '</td>'; // Display M/NO
        $html .= '<td><input type="text" name="name_details[]" value="' . htmlspecialchars($data['name_details']) . '" readonly></td>';
        
        // B/F Balances (Read-only)
        $html .= '<td><input type="number" step="0.01" class="bf-savings" name="bf_savings[]" value="' . htmlspecialchars(number_format($data['bf_savings'], 2, '.', '')) . '" readonly></td>';
        $html .= '<td><input type="number" step="0.01" class="bf-loan" name="bf_loan[]" value="' . htmlspecialchars(number_format($data['bf_loan'], 2, '.', '')) . '" readonly></td>';
        
        // TOTAL REPAID (Auto-Check - read-only)
        $html .= '<td><input type="number" step="0.01" class="total-repaid" value="0.00" readonly></td>';
        
        // INFLOW PAYMENTS (MANUAL INPUT)
        $html .= '<td><input type="number" step="0.01" class="principal" name="principal[]" value="0.00" oninput="calculateAll()"></td>';
        $html .= '<td><input type="number" step="0.01" class="loan-interest" name="loan_interest[]" value="0.00" oninput="calculateAll()"></td>';
        $html .= '<td><input type="number" step="0.01" class="shares" name="shares[]" value="0.00" oninput="calculateAll()"></td>';
        $html .= '<td><input type="number" step="0.01" class="fines" name="fines[]" value="0.00" oninput="calculateAll()"></td>';
        $html .= '<td><input type="number" step="0.01" class="advance-paid" name="advance_paid[]" value="0.00" oninput="calculateAll()"></td>'; // ADDED: ADVANCE PAID
        
        // OUTFLOW DISBURSEMENTS (MANUAL INPUT)
        $html .= '<td><input type="number" step="0.01" class="withdrawal" name="withdrawal[]" value="0.00" oninput="calculateAll()"></td>';
        $html .= '<td><input type="number" step="0.01" class="new-loan" name="new_loan[]" value="0.00" oninput="calculateAll()"></td>';
        $html .= '<td><input type="number" step="0.01" class="new-advance" name="new_advance[]" value="0.00" oninput="calculateAll()"></td>';
        
        // C/F BALANCES (Auto-Calculated by JS, read-only via span)
        $html .= '<td><span class="cf-savings">0.00</span></td>';
        $html .= '<td><span class="cf-loan">0.00</span></td>';
        $html .= '</tr>';
    }
    return $html;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SEEPO RLF LedgerPro - Revolving Loan Fund System</title>
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <header>
        <h1>Social Economic Empowerment Program Integrated Organization</h1>
        <h2>Project: Revolving Loan Fund (RLF) LedgerPro</h2>
    </header>
    
    <div style="padding: 15px 30px; background-color: #555;">
        <?php echo generate_group_dropdown($groups_list, $selected_group_id); ?>
        <a href="admin.php" style="color: #ffb74d; margin-left: 20px;">Manage Groups & Members</a>
        <a href="reports.php" style="color: #8bc34a; margin-left: 20px;">View Reports & History</a>
    </div>

    <?php echo $report_status; // Display success/error message ?>

    <form method="POST" action="index.php?group_id=<?php echo $selected_group_id; ?>">
        <input type="hidden" name="group_id" value="<?php echo $selected_group_id; ?>"> 
        
        <div class="tabs">
            <button type="button" class="tab-button active" onclick="showTab('ledger')">1. Member Ledger (Page 1 Data Entry)</button>
            <button type="button" class="tab-button" onclick="showTab('summary')">2. Group Summary (Page 2 Report)</button>
        </div>

        <div id="ledger" class="tab-content active">
            <h3>GROUP MONTHLY PERFORMANCE FORM - Member Ledger</h3>
            <div class="header-details">
                <label>GROUP NAME: <input type="text" name="groupName" id="groupName" value="<?php echo get_group_name_by_id($groups_list, $selected_group_id); ?>" readonly></label>
                <label>DATE: <input type="date" name="reportDate" id="reportDate" value="<?php echo date('Y-m-d'); ?>" required></label>
                <label>PROJECT: D.L.F. - Revolving Loan Fund</label> 
            </div>
            <div class="header-details">
                <label>OFFICER'S NAME: <input type="text" name="officerName" id="officerName" required></label>
                <label>OFFICER'S SIGN: [Digital Signature/Stamp]</label>
            </div>

            <table id="memberTable">
                <thead>
                    <tr>
                        <th rowspan="2">M/NO</th>
                        <th rowspan="2">MEMBERS NAMES & DETAILS</th>
                        <th colspan="2">B/F BALANCES</th>
                        <th colspan="6">INFLOW PAYMENTS (Money Collected)</th> <th colspan="3">OUTFLOW DISBURSEMENTS (Cash Given Out Today)</th>
                        <th colspan="2">C/F BALANCES (Auto)</th>
                    </tr>
                    <tr>
                        <th>SAVINGS & SHARES B/F</th>
                        <th>LOAN BALANCE B/F</th>
                        <th>TOTAL REPAID (Auto-Check)</th>
                        <th>PRINCIPAL</th>
                        <th>LOAN INTEREST (Manual Input)</th>
                        <th>SHARES THIS MONTH</th>
                        <th>FINES AND CHARGES</th>
                        <th>ADVANCE PAID</th> <th>SAVINGS WITHDRAWAL</th>
                        <th>NEW LOAN</th>
                        <th>NEW ADVANCE</th>
                        <th>SAVINGS & SHARE C/F</th>
                        <th>LOAN BAL C/F</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($selected_group_id): ?>
                        <?php echo generate_member_rows($members_data); ?>
                    <?php else: ?>
                        <tr><td colspan="15" style="text-align: center;">Please select a group above or use 'Manage Groups & Members' to set up a new group.</td></tr> <?php endif; ?>
                </tbody>
            </table>
        </div>

        <div id="summary" class="tab-content">
            <h3>GROUP MONTHLY PERFORMANCE - Summary Report</h3>
            
            <input type="hidden" name="grandTotalSubmitted" id="grandTotalSubmitted" value="0.00">

            <div class="section-box">
                <h4>I. Financial Inflows (Automatic Totals)</h4>
                <label>TOTAL CASH COLLECTED (TOTAL PAID): <span id="summaryTotalPaid" class="auto-total">0.00</span></label>
                <label>TOTAL REPAID (Principal + Interest): <span id="summaryTotalRepaid" class="auto-total">0.00</span></label>
                <label>TOTAL NEW SAVINGS (Shares): <span id="summaryTotalSavings" class="auto-total">0.00</span></label>
                <label>TOTAL FINES AND CHARGES TODAY: <span id="summaryTotalFines" class="auto-total">0.00</span></label>
                <label>TOTAL ADVANCE PAID: <span id="summaryTotalAdvancePaid" class="auto-total">0.00</span></label> </div>

            <div class="section-box">
                <h4>II. Financial Outflows (Group Totals)</h4>
                <label>TOTAL SAVINGS WITHDRAWAL: <span id="totalWithdrawal" class="auto-total">0.00</span></label>
                <label>TOTAL NEW LOANS DISBURSED: <span id="totalNewLoan" class="auto-total">0.00</span></label>
                <label>TOTAL NEW ADVANCES DISBURSED: <span id="totalNewAdvance" class="auto-total">0.00</span></label>
                
                <h4>Specific Expenses (Manual Input)</h4>
                <label>PRV BANKING / Starting Cash Balance: <input type="number" step="0.01" name="prvBanking" id="prvBanking" value="0.00" oninput="calculateSummary()"></label>
                <label>X MEALS: <input type="number" step="0.01" name="expenseMeals" class="expense" value="0.00" oninput="calculateSummary()"></label>
                <label>TRANSPORT: <input type="number" step="0.01" name="expenseTransport" class="expense" value="0.00" oninput="calculateSummary()"></label>
                <label>STATIONARY / PASSBOOKS: <input type="number" step="0.01" name="expenseStationary" class="expense" value="0.00" oninput="calculateSummary()"></label>
                <label>OTHERS (SPECIFY): <input type="number" step="0.01" name="expenseOthers" class="expense" value="0.00" oninput="calculateSummary()"></label>
                <label>TOTAL EXPENSES: <span id="totalExpenses" class="auto-total">0.00</span></label>
            </div>
            
            <div class="section-box final-reconciliation">
                <h3>III. GRAND TOTAL (Ending Cash Balance)</h3>
                <label>GRAND TOTAL (Ending Cash Balance): <span id="grandTotal" class="auto-total">0.00</span></label>
            </div>

            <div class="section-box next-meeting-details">
                <h4>V. Next Meeting Details</h4>
                <label>NEXT MEETING DATE: <input type="date" name="nextDate"></label>
                <label>TIME: <input type="time" name="nextTime"></label>
                <label>VENUE: <input type="text" name="nextVenue"></label>
                <label>STAGE (Agenda): <input type="text" name="nextStage"></label>
                <label>AREA: <input type="text" name="nextArea"></label>
                <label>REMARKS: <input type="text" name="nextRemarks"></label>
            </div>
            
            <button type="submit" style="padding: 15px 30px; background-color: #4a148c; color: white; border: none; border-radius: 5px; font-size: 1.2em; margin-top: 20px; cursor: pointer;">SUBMIT MONTHLY REPORT</button>
        </div>
    </form>
    <script src="scripts.js"></script>
    <?php close_db_connection($conn); ?>
</body>
</html>